VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "KPCI-PDISO8A with Direct I/O COM API"
   ClientHeight    =   6525
   ClientLeft      =   2430
   ClientTop       =   1620
   ClientWidth     =   6075
   LinkTopic       =   "Form1"
   ScaleHeight     =   6525
   ScaleWidth      =   6075
   Begin VB.CommandButton cmdOpen 
      Caption         =   "Open"
      Height          =   495
      Left            =   1680
      TabIndex        =   20
      Top             =   960
      Width           =   2175
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close"
      Enabled         =   0   'False
      Height          =   495
      Left            =   1800
      TabIndex        =   19
      Top             =   5400
      Width           =   2175
   End
   Begin VB.Frame Frame2 
      Caption         =   "Input Channels"
      Enabled         =   0   'False
      Height          =   1335
      Left            =   360
      TabIndex        =   13
      Top             =   1920
      Width           =   5175
      Begin VB.CommandButton cmdRead 
         Caption         =   "Read DI channels"
         Enabled         =   0   'False
         Height          =   375
         Left            =   480
         TabIndex        =   14
         Top             =   480
         Width           =   1695
      End
      Begin VB.Label Label5 
         Caption         =   "Channel 1"
         Height          =   255
         Left            =   3600
         TabIndex        =   18
         Top             =   240
         Width           =   855
      End
      Begin VB.Label Label4 
         Caption         =   "Channel 0"
         Height          =   255
         Left            =   2400
         TabIndex        =   17
         Top             =   240
         Width           =   735
      End
      Begin VB.Label lblChan1 
         BackColor       =   &H8000000E&
         Height          =   255
         Left            =   3600
         TabIndex        =   16
         Top             =   600
         Width           =   735
      End
      Begin VB.Label lblChan0 
         BackColor       =   &H8000000E&
         Height          =   255
         Left            =   2400
         TabIndex        =   15
         Top             =   600
         Width           =   735
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Output Channels"
      Enabled         =   0   'False
      Height          =   1335
      Left            =   360
      TabIndex        =   0
      Top             =   3480
      Width           =   5175
      Begin VB.CheckBox Check1 
         Height          =   375
         Index           =   7
         Left            =   2760
         TabIndex        =   10
         Top             =   480
         Width           =   255
      End
      Begin VB.CheckBox Check1 
         Height          =   375
         Index           =   6
         Left            =   3000
         TabIndex        =   9
         Top             =   480
         Width           =   255
      End
      Begin VB.CheckBox Check1 
         Height          =   375
         Index           =   5
         Left            =   3240
         TabIndex        =   8
         Top             =   480
         Width           =   255
      End
      Begin VB.CheckBox Check1 
         Height          =   375
         Index           =   4
         Left            =   3480
         TabIndex        =   7
         Top             =   480
         Width           =   255
      End
      Begin VB.CheckBox Check1 
         Height          =   375
         Index           =   3
         Left            =   3720
         TabIndex        =   6
         Top             =   480
         Width           =   255
      End
      Begin VB.CheckBox Check1 
         Height          =   375
         Index           =   2
         Left            =   3960
         TabIndex        =   5
         Top             =   480
         Width           =   255
      End
      Begin VB.CheckBox Check1 
         Height          =   375
         Index           =   1
         Left            =   4200
         TabIndex        =   4
         Top             =   480
         Width           =   255
      End
      Begin VB.CheckBox Check1 
         Height          =   375
         Index           =   0
         Left            =   4440
         TabIndex        =   3
         Top             =   480
         Width           =   255
      End
      Begin VB.CommandButton cmdDOChan2 
         Caption         =   "Write DO channel 0"
         Enabled         =   0   'False
         Height          =   375
         Left            =   480
         TabIndex        =   1
         Top             =   480
         Width           =   1935
      End
      Begin VB.Label Label3 
         Caption         =   "bit 7"
         Height          =   255
         Left            =   2760
         TabIndex        =   12
         Top             =   840
         Width           =   375
      End
      Begin VB.Label Label2 
         Caption         =   "bit 0"
         Height          =   255
         Left            =   4440
         TabIndex        =   11
         Top             =   840
         Width           =   375
      End
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   360
      Left            =   240
      TabIndex        =   2
      Top             =   120
      Width           =   1845
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' this example was written in VB6 in Win2KSP1
' tested using a KPCI-PDISO8A board with ISO-850A01 driver revision
Dim KPIO As New KDigitalIo  ' declare instace of our Direct I/O COM object
' in Project|References need a check box by the 'Keithley Digital I/O Library'

Private Sub cmdClose_Click()
KPIO.CloseDevice
End
End Sub

Private Sub cmdDOChan2_Click()
' get value to be written from the check boxes
Dim bitValues As Byte
Dim i As Integer
For i = 0 To 7
bitValues = bitValues + Check1(i).Value * 2 ^ i
Next i
' now write this value to the channel
KPIO.Write 4, bitValues  ' the relays are at an offset of 4
' use ohm meter and look for open or close on the relay outputs
End Sub


Private Sub cmdOpen_Click()
 On Error GoTo ErrHandle

KPIO.OpenDevice "kpciiso", 0  ' driver name, DLinx Config Panel device number
cmdRead.Enabled = True
Frame1.Enabled = True
Frame2.Enabled = True
cmdRead.Enabled = True
cmdDOChan2.Enabled = True
cmdClose.Enabled = True
Exit Sub

ErrHandle:
cmdRead.Enabled = False
Frame1.Enabled = False
Frame2.Enabled = False
cmdRead.Enabled = False
cmdDOChan2.Enabled = False
cmdClose.Enabled = False
MsgBox " Error initializing COM object for KPCI-PPDISO8A. Verify Device Number is 0 or change this code."

End Sub

Private Sub cmdRead_Click()
lblChan0.Caption = KPIO.Read(0)
lblChan1.Caption = KPIO.Read(4)
' the read at offset of 4 is just a read back of the last written value
' to the output/relay control channel
End Sub


